#
# file:     game.py
#
# about:    game thingy..
#
# author:   Tom "Knio" Flanagan
#
# contact:  theknio@gmail.com
#           irc.freenode.net - Knio - #python #pygame #py
#           * comments welcome *
#
# license:  Public Domain
#

from space.space    import Space
from space.player   import Player
from space.planet   import Planet
from space.user     import User, Team

import time
import sys
import traceback

FPS = 40.

# TODO: change current directory so that images/fonts can load

class Game(object):
    def __init__(self):
        self.game = Space()
        self.modules = [self.game]

    def addPlanet(self, size, pos):
        Planet(self.game, size, pos)
        
    def run(self):
        start = time.clock()
        while not self.game.done:
            t = self.game.turn - int((time.clock() - start) * FPS)
            for i in self.modules:
                i.tick(t)
            sys.stdout.write(('%2s' % t).rjust(4))
            if t >= 1:
                time.sleep(t/(5*FPS))
            sys.stdout.write('\b\b\b\b')
        print self.game.turn, self.view.turn, '%.1f' % (1.0 * FPS * self.view.turn / self.game.turn), 'FPS'
        for i in self.modules:
            i.quit()


def main():
    game = Game()
    try:
        args = list(sys.argv[1:])
        mode = args[0].lower()
        args = args[1:]
        if not mode in ['client', 'server', 'single']:
            raise Exception('mode must be either \'client\', \'server\', or \'single\'')
        if mode == 'server':
            from net.server     import Server
            host = ''
            port = 41787
            name = 'Space Game Server'
            while args:
                if args[0] == '-p':
                    port = int(args[1])
                    args = args[2:]
                elif args[0] == '-b':
                    host = args[1]
                    args = args[2:]
                elif args[0] == '-n':
                    name = args[1]
                    args = args[2:]
                else:
                    raise Exception('invalid option: %s' % args[0])
            game.name   = name
            game.server = Server(game.game, (host, port))
            
            game.modules.append(game.server)
            
            game.addPlanet(100, (  500, 500))
            game.addPlanet(300, (-1000,1000))
            game.addPlanet(150, (-500,    0))
            game.addPlanet(200, (-1500, 200))
            
        if mode == 'client':
            from net.client     import Client
            from view.view      import View
            from view.control   import Input
            host = 'localhost'
            port = 41787
            bindhost = ''
            bindport = 0
            width   = 800
            height  = 600
            while args:
                if args[0] == '-p':
                    port = int(args[1])
                    args = args[2:]
                elif args[0] == '-h':
                    host = args[1]
                    args = args[2:]
                elif args[0] == '-b':
                    bindhost = args[1]
                    args = args[2:]
                elif args[0] == '-n':
                    bintport = int(args[1])
                    args = args[2:]
                elif args[0] == '-r':
                    width = int(args[1])
                    height = width*3/4
                    args = args[2:]
                else:
                    raise Exception('invalid option: %s' % args[0])
            game.user   = User(game.game)
            game.client = Client(game.game, game.user, (host, port), (bindhost, bindport))
            game.view   = View(game.game, (width, height), game.user)
            game.kbrd   = Input(game)
            
            game.modules.append(game.client)
            game.modules.append(game.view)
            game.modules.append(game.kbrd)
            
        if mode == 'single':
            from view.view      import View
            from view.control   import Input
            width   = 800
            height  = 600
            game.user = User(game.game)
            while args:
                if args[0] == '-r':
                    width = int(args[1])
                    height = width*3/4
                    args = args[2:]
                else:
                    raise Exception('invalid option: %s' % args[0])
            game.user   = User(game.game)
            #game.player = Player(game.game, game.user, (0, 0, 0, 0, 0))
            game.team   = Team(game.game, color=(0, 0, 255))
            game.view   = View(game.game, (width, height), game.user)
            game.kbrd   = Input(game)
            
            game.user.team = game.team
            game.modules.append(game.view)
            game.modules.append(game.kbrd)
            
            game.addPlanet(100, (  500, 500))
            game.addPlanet(300, (-1000,1000))
            game.addPlanet(150, (-500,    0))
            game.addPlanet(200, (-1500, 200))
            
    except Exception, e:
        print '-- Space Game --'
        print 'Usage: python game.py mode [OPTION]...'
        print
        print 'mode: client   server   single'
        print
        print 'server options:'
        print '-b   bind address    (default: null)'
        print '-p   port            (default: 41787)'
        print '-n   name            (default: \'Space Game Server\')'
        print
        print 'client options:'
        print '-h   host            (default: localhost)'
        print '-p   port            (default: 41787)'
        print '-b   bind address    (default: localhost)'
        print '-n   bind port       (default: 0)'
        print '-r   screen width    (default: 800)'
        print
        print 'single options:'
        print '-r   screen width    (default: 800)'
        print
        print '----------------------------------------'
        print 'Error:'
        traceback.print_exc()
        print
        return
    
    game.run()
        
    
if __name__ == '__main__':
    main()
    
