#
# file:     client.py
#
# about:    space game client
#
# author:   Tom "Knio" Flanagan
#
# contact:  theknio@gmail.com
#           irc.freenode.net - Knio - #python #pygame #py
#           * comments welcome *
#
# license:  Public Domain
#

import  socket
from    protocol2       import *
from    space.user      import User, Team
from    space.player    import Player
from    space.laser     import Laser


class Client(object):
    def __init__(self, game, user, addr=('', 0), bindaddr=('', 0)):
        self.game = game
        self.user = user
        self.socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        self.socket.bind(bindaddr)
        self.socket.setblocking(False)
        self.addr = socket.gethostbyname(addr[0]), addr[1]
        self.status = 0
        if self.addr[0] and self.addr[1]:
            self.connect()
        
    def connect(self, addr=None):
        if addr:
            self.addr = socket.gethostbyname(addr[0]), addr[1]
        if (not self.addr) or not (self.addr[0] and self.addr[1]):
            raise Exception('client has no address to connect to')
        message = JoinMessage()
        message.append(NetUser(self.user))
        self.send(message)
        self.status = 1
        
      
    def updated(self):
        # find a list of objects that have been updated
        # what can the client update?
        # its user, its player, and lasers..
        updated = []
        if self.user.updated:
            updated.append(self.user)
            self.user.updated = 0
        if self.user.player:
            updated.append(self.user.player)
        for i in self.game.objects.values():
            if i.updated:
                updated.append(i)
                i.updated = 0
        return updated
        
  
    def tick(self, t):
        self.read()
        if not self.game.turn % 10: #TODO: come up with a smart way of sending packets
            self.sendUpdate()
        
    def read(self):
        while 1:
            try:
                data, addr = self.socket.recvfrom(1024)
            except socket.error:
                return
            if not addr == self.addr:
                print addr
                raise Exception('data is not from server')
            self.recv(data, addr)
            
    def send(self, data):
        if isinstance(data, Message):
            data = data.toData()
        self.socket.sendto(data, self.addr)
            
    def recv(self, data, addr):
        try:
            message = Message(data)
        except Exception, e:
            print 'Parsing error'
            traceback.print_exc()
        if not isinstance(message, UpdateMessage):
            print message
        if isinstance(message, JoinMessage):
            self.status = 2
        if isinstance(message, UpdateMessage):
            self.update(message)
       
    def update(self, message):
        for i in message:
            print i
            if isinstance(i, NetTeam):
                i.toObject(self.game.getTeam(i.id), self.game)
            if isinstance(i, NetUser):
                i.toObject(self.game.getUser(i.id), self.game)
            if isinstance(i, NetPlayer):
                i.toObject(self.game.getPlayer(i.id), self.game)
            if isinstance(i, NetLaser):
                i.toObject(self.game.getObject(Laser, i.id), self.game)
            if isinstance(i, NetPlanet):
                i.toObject(self.game.getPlanet(i.id), self.game)
            
       
    def sendUpdate(self):
        message = UpdateMessage()
        for i in self.updated():
            if isinstance(i, User):
                message.append(NetUser(i))
            if isinstance(i, Player):
                message.append(NetPlayer(i))
            if isinstance(i, Laser):
                message.append(NetLaser(i))
        self.send(message)
        
    def quit(self):
        if self.status != 0:
            self.send(QuitMessage())