#
# file:     connection.py
#
# about:    protocol class
#
# author:   Tom "Knio" Flanagan
#
# contact:  theknio@gmail.com
#           irc.freenode.net - Knio - #python #pygame #py
#           * comments welcome *
#
# license:  Public Domain
#

from parser import Message, NetObject, NetList


class StatusMessage(Message):   pass

class NetString(NetList):
    value = 'c'
    
    def prewrite(self, children):
        self.string = ''.join(self.children)
        
    def write(self):
        pass
        
    def read(self):
        self.string = ''.join(self.children)


class NetGame(NetObject):
    name    = '20p'
    turn    = 'I'
    teams   = 'B'
    users   = 'B'
    players = 'B'
    planets = 'B'
    objects = 'H'

    def prewrite(self, game):
        self.teams      = len(game.teams)
        self.users      = len(game.users)
        self.players    = len(game.players)
        self.planets    = len(game.planets)
        self.objects    = len(game.objects)


class NetTeam(NetObject):
    id      = 'I'
    name    = '10p'
    red     = 'B'
    blue    = 'B'
    green   = 'B'
    
    def prewrite(self, team):
        self.color = team.color
    
    def write(self):
        self._red, self._green, self._blue = self.color
        
    def read(self):
        self.color = self._red, self._blue, self._green
        

class NetUser(NetObject):
    id      = 'I'
    name    = '10p'
    team    = 'I'
    player  = 'I'
    kills   = 'B'
    deaths  = 'B'

    def prewrite(self, user):
        self.team   = user.team.id
        self.player = user.player and self.player.id or 0
        

    
class NetPlayer(NetObject):
    id      = 'I'
    user    = 'I'
    hp      = 'B'
    fuel    = 'B'
    x       = 'f'
    y       = 'f'
    a       = 'f'
    m       = 'f'
    firing  = 'B'
    turning = 'b'
    thrusting = 'b'
    
    def prewrite(self, player):
        self.reload     = player.reload
        self.user       = player.user.id
    
    def write(self):
        self._hp         = int(self.hp*255)
        self._fuel       = int(self.fuel*255)
        self._turning    = int(self.turning*127)
        self._thrusting  = int(self.thrusting*127)
        self._firing     = (self.firing << 7) + self.reload
        
    def read(self):
        self.hp         = self._hp/255.
        self.fuel       = self._fuel/255.
        self.turning    = self._turning/127.
        self.thrusting  = self._thrusting/127.
        self.firing     = self._firing & 0xe0
        self.reload     = self._firing & 0x7f
        
class NetPlanet(NetObject):
    _type   = 'N'
    id      = 'I'
    team    = 'I'
    owned   = 'B'
    x       = 'f'
    y       = 'f'
    size    = 'f'
    
    def prewrite(self, planet):
        self.team   = planet.team.id
    
    def write(self):
        self._owned = int(self.owned*255)
        
    def read(self):
        self.owned = self._owned/255.
        

class NetLaser(NetObject):
    




    
    