#
# file:     protocol2.py
#
# about:    protocol class
#
# author:   Tom "Knio" Flanagan
#
# contact:  theknio@gmail.com
#           irc.freenode.net - Knio - #python #pygame #py
#           * comments welcome *
#
# license:  Public Domain
#

import math
from parser2 import *

class StatusMessage (Message):  pass
class JoinMessage   (Message):  pass
class QuitMessage   (Message):  pass
class UpdateMessage (Message):  pass
class ErrorMessage  (Message):  pass


class Error(NetObject):
    code    = uint8
    message = string

class NetGame(NetObject):
    turn    = uint32
    name    = string
    teams   = uint8
    users   = uint8
    players = uint8
    planets = uint8
    objects = uint16
    
    def fromObject(self, obj, game):
        self.turn   = obj.turn
        self.name   = obj.name
        self.teams  = len(obj.teams)
        self.users  = len(obj.users)
        self.players= len(obj.players)
        self.planets= len(obj.planets)
        self.objects= len(obj.objects)

class NetTeam(NetObject):
    id      = uint32
    name    = string
    red     = uint8
    blue    = uint8
    green   = uint8
    
    def toObject(self, obj, game):
        obj.id      = self.id
        obj.name    = self.name
        obj.color   = self.red, self.green, self.blue  
     
    def fromObject(self, obj, game):
        self.id     = obj.id
        self.name   = obj.name
        self.red, self.green, self.blue = obj.color
        
class NetUser(NetObject):
    id      = uint32
    name    = string
    team    = uint32
    player  = uint32
    kills   = uint8
    deaths  = uint8
    
    def fromObject(self, obj, game):
        self.id     = obj.id
        self.name   = obj.name
        self.team   = obj.team.id
        self.player = obj.player and obj.player.id or 0 # ugh...
        self.kills  = obj.kills
        self.deaths = obj.deaths
        
    def toObject(self, obj, game):
        obj.id      = self.id
        obj.name    = self.name
        obj.team    = game.getTeam(self.team)
        obj.player  = self.player and game.getPlayer(self.player) or None # ...what if this is 0? (this might work)
        obj.kills   = self.kills
        obj.deaths  = self.deaths
        if self.player:
            obj.player.user = obj
        
class NetPlayer(NetObject):
    id      = uint32
    user    = uint32
    x       = float4
    y       = float4
    a       = float4
    m       = float4
    hp      = uint8
    fuel    = uint8
    firing  = uint8
    turning = int8
    thrusting = int8
    
    def fromObject(self, obj, game):
        self.id         = obj.id
        self.user       = obj.user.id
        self.x          = obj.x
        self.y          = obj.y
        self.a          = obj.a
        self.m          = obj.m
        self.hp         = int(obj.hp*255)
        self.fuel       = int(obj.fuel*255)
        self.turning    = int(obj.turning*127)
        self.thrusting  = int(obj.thrusting*127)
        self.firing     = (obj.firing << 7) + obj.reload

    def toObject(self, obj, game):
        obj.id          = self.id
        obj.user        = game.getUser(self.user)
        obj.x           = self.x
        obj.y           = self.y
        obj.a           = self.a
        obj.m           = self.m
        obj.hp          = self.hp/255.
        obj.fuel        = self.fuel/255.
        obj.turning     = self.turning/127.
        obj.thrusting   = self.thrusting/127.
        obj.firing      = self.firing & 0xe0
        obj.reload      = self.firing & 0x7f
        obj.user.player = obj

class NetPlanet(NetObject):
    id      = uint32
    team    = uint32
    owned   = uint8
    x       = float4
    y       = float4
    size    = uint16

    def fromObject(self, obj, game):
        self.id     = obj.id
        self.team   = obj.team.id
        self.owned  = int(obj.owned*255)
        self.x      = obj.x
        self.y      = obj.y
        self.size   = obj.size
        
    def toObject(self, obj, game):
        obj.id      = self.id
        obj.team    = game.getTeam(self.team)
        obj.owned   = self.owned/255.
        obj.x       = self.x
        obj.y       = self.y
        obj.size    = self.size
        obj.mass   = (4 * math.pi * self.size ** 3) / 3

class NetLaser(NetObject):
    id      = uint32
    player  = uint32
    x       = float4
    y       = float4
    a       = float4
    m       = float4
    
    def fromObject(self, obj, game):
        self.id     = obj.id
        self.player = obj.player.id
        self.x      = obj.x
        self.y      = obj.y
        self.a      = obj.a
        self.m      = obj.m
        
    def toObject(self, obj, game):
        obj.id     = self.id
        obj.player = game.getPlayer(self.player)
        obj.x      = self.x
        obj.y      = self.y
        obj.a      = self.a
        obj.m      = self.m
        
    
    




