#
# file:     server.py
#
# about:    space game server
#
# author:   Tom "Knio" Flanagan
#
# contact:  theknio@gmail.com
#           irc.freenode.net - Knio - #python #pygame #py
#           * comments welcome *
#
# license:  Public Domain
#

import  socket
import  traceback
import  time
from    protocol2       import *
from    space.player    import Player
from    space.laser     import Laser

class Client(object):
    def __init__(self, game, addr, id, user):
        self.game       = game
        self.addr       = addr
        self.id         = id
        self.user       = user
        self.players    = {}
        self.objects    = {}
        self.planets    = {}
        self.users      = {}
        self.teams      = {}

    def update(self):
        for i in self.game.players:
            check that the clients version of objects match the servers and vice versa


class Server(object):
    def __init__(self, game, addr=('', 1787)):
        self.game = game
        self.clients = {}
        self.client = 0
        
        self.socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        self.socket.bind(addr)
        self.socket.setblocking(False)
        
    def tick(self, t):
        self.read()
        if not self.game.turn % 40:
            for i in self.clients.values():
                self.sendTeams(i)
                self.sendUsers(i)
                self.sendPlanets(i)
                self.sendPlayers(i)
                self.sendLasers(i)
        
    def read(self):
        while 1:
            try:
                data, addr = self.socket.recvfrom(1024)
            except socket.error:
                return
            self.recv(data, addr)
            
    def send(self, data, addr):
        if isinstance(data, Message):
            data = data.toData()
        if isinstance(addr, Client):
            addr = addr.addr
        self.socket.sendto(data, addr)
            
    def recv(self, data, addr):
        try:
            message = Message(data)
        except Exception, e:
            print 'Parsing error'
            traceback.print_exc()
            return
        if not isinstance(message, UpdateMessage):
            print message
        if isinstance(message, StatusMessage):
            self.sendStatus(addr)
        if isinstance(message, JoinMessage):
            try:    self.joinGame(message, addr)
            except ProtocolError, e:
                self.send(ErrorMessage(Error(string=e)), addr)
        if isinstance(message, UpdateMessage):
            self.update(message, self.clients[addr])
            
    def update(self, message, client):
        # what is the client allowed to update?
        for i in message:
            if not i.id>>24 == 0:
                raise ProtocolError('you are only allowed to update objects you created')
            i.id = client.id<<24 & i.id
                # TODO: conditions for editing all these objects
            if isinstance(i, NetTeam):
                i.toObject(self.game.getTeam(i.id), self.game)
            if isinstance(i, NetUser):
                i.toObject(self.game.getUser(i.id), self.game)
            if isinstance(i, NetPlayer):
                i.toObject(self.game.getPlayer(i.id), self.game)
            if isinstance(i, NetLaser):
                i.toObject(self.game.getObject(Laser, i.id), self.game)
        
        
    def sendStatus(self, addr):
        message = StatusMessage()
        message.add(NetGame(self.game, self.game))
        for i in self.game.teams.values():   message.add(NetTeam(i, self.game))
        for i in self.game.users.values():   message.add(NetUser(i, self.game))
        for i in self.game.players.values(): message.add(NetPlayer(i, self.game))
        for i in self.game.planets.values(): message.add(NetPlanet(i, self.game))
        self.send(message, addr)
        
        
        
    def sendObjects(self, map, type, client):
        message = UpdateMessage()
        for i in map.values():
            net = type(i)
            if i.id >> 24 == client.id:
                i.id = i.id & 0x00ffffff
            message.append(net)
        self.send(message, client)
        
    def sendTeams(self, client):
        return self.sendObjects(self.game.teams, NetTeam, client)
        
    def sendUsers(self, client):
        return self.sendObjects(self.game.users, NetUser, client)
        
    def sendPlanets(self, client):
        return self.sendObjects(self.game.planets, NetPlanet, client)
        
    def sendPlayers(self, client):
        return self.sendObjects(self.game.players, NetPlayer, client)
        
    def sendLasers(self, client):
        return self.sendObjects(self.game.objects, NetLaser, client)
        
    def joinGame(self, message, addr):
        if not len(message) == 1:           raise ProtocolError('JoinMessage should contain exactly 1 child')
        if not type(message[0]) == NetUser: raise ProtocolError('JoinMessage should contain a NetUser')
        netuser = message[0]
        # TODO: conditions for joining (max users? banned? duplicate nick?)
        self.client += 1
        id = self.client
        netuser.id = id<<24 | netuser.id
        user = self.game.getUser(netuser.id)
        netuser.toObject(user, self.game)
        client = Client(self.game, addr, id, user)
        self.clients[addr] = client
        
        # TODO: condisions to playing game
        Player(self.game, user)
        message = JoinMessage()
        self.send(message, client)
        self.sendTeams(client)
        self.sendUsers(client)
        self.sendPlanets(client)
        self.sendPlayers(client)
        self.sendLasers(client)
        