#
# file:     laser.py
#
# about:    laser beam
#
# author:   Tom "Knio" Flanagan
#
# contact:  theknio@gmail.com
#           irc.freenode.net - Knio - #python #pygame #py
#           * comments welcome *
#
# license:  Public Domain
#

from object import Object

class Laser(Object):
    def __init__(self, game, player=None, pos=(0., 0., 0., 0., 0.), id=None):
        Object.__init__(self, game, pos, id=id)
        self.player = player
        self.life   = 100
        
    def tick(self):
        Object.tick(self)
        i = self.collide() or self.collidePlayer()
        if i:
            i.hit(self)
            self.die()
        if self.life < 0:
            self.die()
        self.life -= 1
        
    def die(self):
        self.game.removeObject(self)
        
    def collidePlayer(self):
        for i in self.game.players.values():
            if i is self.player:
                continue
            d = i.distance(self)
            if d < 40:
                return i
    