#
# file:     object.py
#
# about:    arbitrary game object
#
# author:   Tom "Knio" Flanagan
#
# contact:  knio@h4xn3t.net
#           theknio@gmail.com
#           irc.freenode.net - Knio - #python #pygame #py
#           * comments welcome *
#
# license:  Public Domain
#

from vector import Vector
import math

class Object(Vector):    
    def __init__(self, game, vect=(0., 0., 0., 0., 0.), id=None):
        Vector.__init__(self, *vect[:4])
        self.game   = game
        self.f      = vect[4]
        self.id     = id
        self.updated= 1
        self.init()
        
    def init(self):
        self.game.addObject(self)
        
    def tick(self):
        self.move()
        
    def hit(self, planet):
        pass
       
    def gravity(self):
        self.add(self.game.getGravity(self.x, self.y))
        
    def collide(self):
        for i in self.game.planets.values():
            d = i.distance(self)
            if d < i.size:
                self.hit(i)
                return i
                

    def __repr__(self):
        return '<Object(id=%s, %s, %s, %s, %s>' % (self.id, self.x, self.y, self.a, self.m)