#
# file:     planet.py
#
# about:    planet class
#
# author:   Tom "Knio" Flanagan
#
# contact:  knio@h4xn3t.net
#           theknio@gmail.com
#           irc.freenode.net - Knio - #python #pygame #py
#           * comments welcome *
#
# license:  Public Domain
#

from vector import Vector
import math

class Planet(Vector):
    def __init__(self, game, size=0., pos=(0., 0.), id=None):
        Vector.__init__(self, *pos)
        self.game   = game
        self.id     = id
        self.size   = float(size)
        self.mass   = (4 * math.pi * self.size ** 3) / 3
        self.team   = None
        self.owned  = 0.0 # TODO: add mass in here somewhere -- larger planets take longer to capture
        self.game.addPlanet(self)
        self.game.getTeam(0).addPlanet(self)
        
    def tick(self):
        if self.owned:
            self.owned = min(self.owned + 1./8192, 1.0)
        
    def dock(self, player):
        if self.team is player.user.team:
            self.owned = min(self.owned   + 1./256,   1.0)
            player.fuel = min(player.fuel + self.owned/256, 1.0)
            player.hp   = min(player.hp   + self.owned/8192,  1.0)
        else:
            self.owned = max(self.owned - 1./256, 0.0)
        if self.owned == 0.0:
            player.user.team.addPlanet(self)

    def hit(self, laser):
        if not self.team is laser.player.user.team:
            self.owned = max(self.owned - 8./256, 0.0)
            if not self.owned:
                self.game.teams[0].addPlanet(self)
                
    def __setattribute__(self, name, value):
        if name == 'team':
            value.addPlanet(self)
        return object.__setattribute__(self, name, value)
        
    def __repr__(self):
        return '<Planet(id=%s, team=%s, %s, %s, %s>' % (self.id, self.team.id, self.x, self.y, self.size)