#
# file:     space.py
#
# about:    main game class
#
# author:   Tom "Knio" Flanagan
#
# contact:  knio@h4xn3t.net
#           theknio@gmail.com
#           irc.freenode.net - Knio - #python #pygame #py
#           * comments welcome *
#
# license:  Public Domain
#

from vector import Vector
from user   import User, Team
from player import Player
from planet import Planet

class Space(object):
    def __init__(self, name='Space Game'):
        self.name       = name
        self.players    = {}
        self.objects    = {}
        self.planets    = {}
        self.users      = {}
        self.teams      = {}
        self.turn       = 0
        self.id         = 0
        self.gravityMap = {}
        self.done       = False
        # ids arnt being registered properly..
        Team(self, name='None', id=0)
         
    def getId(self):
        self.id += 1
        return self.id
    
    def add(self, type, obj):
        if obj.id is not None: # all objects should have an id attribute now.. set to None or a number
            id = obj.id
        else:
            id = self.getId()
        if id in type:
            if type[id] is not obj:
                print id
                print type[id]
                print obj
                raise ValueError('argh!!') # that id  already exists, and it is not that object.. something is broken
            return
        type[id] = obj
        obj.id = id
        obj.version = 1 # for the netcode netcode
    
    def remove(self, type, obj):
        if obj.id not in type:
            return
        del type[obj.id]
        # need to keep track of objects that are deleted, so that we can tell clients
    
    def get(self, type, klass, id=None):
        if id == None:
            id = self.getId()
        try:    return type[id]
        except KeyError: pass            
        obj = klass(self, id=id) # this might work now (do all objects accept a single parameter to __init__?)
        if not obj.id == id:     # ^- this calls add() when the object is created
            raise ValueError('something messed up')         # add() is probably checking these too..
        if not type[id] is obj:
            raise ValueError('something else messed up')
        return obj
        
    def addObject(self, object):
        self.add(self.objects, object)
        
    def addPlayer(self, player):
        self.add(self.players, player)
        
    def addPlanet(self, planet):
        self.add(self.planets, planet)
        self.gravitymap = {}
        
    def addUser(self, user):
        self.add(self.users, user)
        
    def addTeam(self, team):
        self.add(self.teams, team)
        
        
    def removeObject(self, object):
        self.remove(self.objects, object)

    def removePlayer(self, player):
        self.remove(self.players, player)
        
    def removePlanet(self, planet):
        self.remove(self.planets, planet)
        self.gravityMap = {}
        
    def removeUser(self, user):
        self.remove(self.users, user)
        user.team.user.remove(user)
        if not user.team.users:
            self.removeTeam(user.team)
            
    def removeTeam(self, team):
        if team.id == 0:
            raise ArgumentError('cannot remove team 0')
        self.remove(self.teams, team)
        for i in team.users:
            self.teams[0].addUser(i)
            
    def getObject(self, klass, id=None):
        return self.get(self.objects, klass, id)
            
    def getPlayer(self, id=None):
        return self.get(self.players, Player, id)
        
    def getPlanet(self, id=None):
        return self.get(self.planets, Planet, id)
        
    def getUser(self, id=None):
        return self.get(self.users, User, id)
        
    def getTeam(self, id=None):
        return self.get(self.teams, Team, id)
        
        
    def calcGravity(self, x, y):
        vect = Vector(x, y)
        for i in self.planets.values():
            dx = x - i.x
            dy = y - i.y
            ds = dx*dx+dy*dy
            if ds <= i.size**2:
                continue
            a = vect.angle(i)
            m = i.mass/(dx*dx+dy*dy)
            vect.add(Vector(0, 0, a, m))
        vect.div(1024)
        return vect

    def getGravity(self, x, y):
        try:
            x = int(x)/10*10
            y = int(y)/10*10
            return self.gravityMap[x,y]
        except KeyError:
            vect = self.calcGravity(x,y)
            self.gravityMap[x,y] = vect
            return vect
    
    def tick(self, t):
        self.turn += 1
        for i in self.players.values():
            i.tick()
        for i in self.objects.values():
            i.tick()
        for i in self.planets.values():
            i.tick()
        

    def quit(self):
        self.done = True





