#
# file:     user.py
#
# about:    user info class
#
# author:   Tom "Knio" Flanagan
#
# contact:  knio@h4xn3t.net
#           theknio@gmail.com
#           irc.freenode.net - Knio - #python #pygame #py
#           * comments welcome *
#
# license:  Public Domain
#

from player import Player

class Team(object):
    def __init__(self, game, color=(255, 255, 255), name='Team', id=None):
        self.game   = game
        self.id     = id
        self.users  = []
        self.planets= []
        self.color  = color
        self.name   = name
        self.updated=1
        self.game.addTeam(self)
    
    def addUser(self, user):
        if user in self.users: return
        self.users.append(user)
        user.team = self
        
    def addPlanet(self, planet):
        if planet.team:
            planet.team.removePlanet(planet)
        planet.team = self
        self.planets.append(planet)
        
        
    def removePlanet(self, planet):
        self.planets.remove(planet)
        
    def __repr__(self):
        return '<Team(id=%s, name=%s, color=%s)>' % (self.id, self.name, self.color)

class User(object):
    def __init__(self, game, name='Player', id=None):
        self.game   = game
        self.id     = id
        self.player = None
        self.name   = name
        self.team   = self.game.getTeam(0)
        self.kills  = 0
        self.deaths = 0
        self.updated=1
        self.game.addUser(self)
        
    def setPlayer(self, player):
        self.player = player
        self.player.user = self
        
    def setTeam(self, team):
        team.addUser(self)
        
    def die(self):
        self.deaths += 1
        # let the server do this
        #if self.team.planets:
        #    self.player = Player(self.game, self, (self.team.planets[-1].x, self.team.planets[-1].y+1, 0., 0., 0.))
            
    def __setattribute__(self, name, value):
        # warnging: these could cause alot of infinate recursion
        if name == 'player':
            value.user = self
        if name == 'team':
            value.addUser(self)
        return object.__setattribute__(self, name, value)
        
    def __repr__(self):
        return '<User(id=%s, name=%s, team=%s, player=%s>' % (self.id, self.name, self.team.id, self.player and self.player.id or 0)

