#
# file:     control.py
#
# about:    user controls
#
# author:   Tom "Knio" Flanagan
#
# contact:  knio@h4xn3t.net
#           theknio@gmail.com
#           irc.freenode.net - Knio - #python #pygame #py
#           * comments welcome *
#
# license:  Public Domain
#

import pygame
from   pygame.constants import *

class Input(object):
    def __init__(self, top):
        self.top        = top
        self.exiting    = False
        
    def tick(self, t):
        for i in pygame.event.get():
            if i.type == QUIT:
                self.exiting = True
                self.top.game.done = True
            if i.type == KEYDOWN:
                if self.top.user.player:
                    self.movePlayer(i)
                if i.key == K_ESCAPE:   self.exiting = True; self.top.game.done = True
                # TODO: move camera and such when there is no player
            if i.type == KEYUP:
                if self.top.user.player:
                    self.movePlayer(i)
  
    
    def movePlayer(self, i):
        if i.type == KEYDOWN:
            if i.key == K_UP:       self.top.user.player.thrusting = 1.0
            if i.key == K_DOWN:     self.top.user.player.thrusting =-0.5
            if i.key == K_LEFT:     self.top.user.player.turning = 1.0
            if i.key == K_RIGHT:    self.top.user.player.turning =-1.0
            if i.key == K_SPACE:    self.top.user.player.firing = 1
           
            if i.key == K_PAGEUP:   self.top.view.userzoom *= 1.2
            if i.key == K_PAGEDOWN: self.top.view.userzoom *= 0.8
                
        if i.type == KEYUP:
            if i.key == K_UP:       self.top.user.player.thrusting = 0.0
            if i.key == K_DOWN:     self.top.user.player.thrusting = 0.0
            if i.key == K_LEFT:     self.top.user.player.turning = 0.0
            if i.key == K_RIGHT:    self.top.user.player.turning = 0.0
            if i.key == K_SPACE:    self.top.user.player.firing = 0  
    
    
    def quit(self):
        pass
 