#
# file:     laser.py
#
# about:    laser renderer
#
# author:   Tom "Knio" Flanagan
#
# contact:  knio@h4xn3t.net
#           theknio@gmail.com
#           irc.freenode.net - Knio - #python #pygame #py
#           * comments welcome *
#
# license:  Public Domain
#

from object import Object
from space.vector import Vector
import pygame

class Laser(Object):
    def tick(self):
        vect = Vector(self.object)
        vect.move(self.object.f, 100.0)
        start   = self.pos()
        end     = self.view.pos((vect.x, vect.y))
        w       = int(5. / self.view.zoom) + 1
        
        pygame.draw.line(self.view.screen, self.object.player.user.team.color, start, end, w)
        