#
# file:     minimap.py
#
# about:    minimap renderer
#
# author:   Tom "Knio" Flanagan
#
# contact:  theknio@gmail.com
#           irc.freenode.net - Knio - #python #pygame #py
#           * comments welcome *
#
# license:  Public Domain
#

import pygame

class Minimap(object):
    def __init__(self, view, game, size=200, scale=50):
        self.view   = view
        self.game   = game
        self.size   = size
        self.scale  = scale
        
    def pos(self, (x, y)):
        return (int(x/self.scale) + self.size/2 + self.view.w-self.size,
               -int(y/self.scale) + self.size/2)
        
    def tick(self):
        #self.view.screen.fill((64, 64, 64), (self.view.w-200, 0, 200, 200))
        pygame.draw.line(self.view.screen, (32, 32, 32), (self.view.w-self.size, 0), (self.view.w-self.size, self.size), 1)
        pygame.draw.line(self.view.screen, (32, 32, 32), (self.view.w-self.size, self.size), (self.view.w, self.size), 1)
        
        for i in self.game.planets.values():
            self.renderPlanet(i)
            
        for i in self.game.players.values():
            self.renderPlayer(i)
            
        self.renderOrbit()
            
    def renderPlanet(self, planet):
        pos = self.pos((planet.x, planet.y))
        r = int(planet.size/50)
        c1 = planet.team.color
        c2 = [int(i*planet.owned/2) for i in c1]
        pygame.draw.circle(self.view.screen, c2, pos, r-1, 0)
        pygame.draw.circle(self.view.screen, c1, pos, r, 1)


    def renderPlayer(self, player):
        pos = self.pos((player.x, player.y))
        self.view.screen.fill(player.user.team.color, pos + (2, 2))
        
    def renderOrbit(self):
        if not self.view.user.player:
            return
        lines = map(self.pos, self.view.user.player.orbit[::self.scale/10])
        self.view.screen.set_clip((self.view.w-self.size, 0, self.size, self.size))
        if len(lines) > 1:
            pygame.draw.lines(self.view.screen, [i/2 for i in self.view.user.team.color], False, lines, 1)
        self.view.screen.set_clip()