#
# file:     object.py
#
# about:    generic object renderer
#
# author:   Tom "Knio" Flanagan
#
# contact:  knio@h4xn3t.net
#           theknio@gmail.com
#           irc.freenode.net - Knio - #python #pygame #py
#           * comments welcome *
#
# license:  Public Domain
#

import pygame
import math
import sys
import os

class Object(object):
    image   = 'images/object.png'
    images  = {}
    def __init__(self, obj, view):
        self.object = obj
        self.view   = view
        self.init()
        
    def init(self):
        pass
        
    def makeImage(self, (angle, scale, color)):
        image = pygame.image.load(self.image).convert()
        image.set_colorkey((0,0,0))
        rect = image.get_rect()
        w = rect.width  / scale
        h = rect.height / scale
        array  = pygame.surfarray.array3d(image)
        array  = array * color
        array  /= 255 
        pygame.surfarray.blit_array(image, array)
        image = pygame.transform.scale(image, (int(h), int(w)))
        image = pygame.transform.rotate(image, angle)
        return image
        
    def getImage(self):
        o = self.object
        angle = int(math.degrees(o.f)-90)/4*4 % 360
        scale = int(self.view.zoom*16)/16.
        key = (angle, scale, (255, 255, 255))
        try:
            return self.images[key]
        except KeyError:
            image = self.makeImage(key)
            self.images[key] = image
            return image
    
    def pos(self):
        return self.view.pos((self.object.x, self.object.y))
    
    def tick(self):
        image = self.getImage()
        rect = image.get_rect() # kw args go here [pygame 1.7]
        x, y = self.pos()
        x = x - rect.w/2
        y = y - rect.h/2
        self.view.screen.blit(image, (x, y))
        
        