#
# file:     planet.py
#
# about:    planet renderer
#
# author:   Tom "Knio" Flanagan
#
# contact:  knio@h4xn3t.net
#           theknio@gmail.com
#           irc.freenode.net - Knio - #python #pygame #py
#           * comments welcome *
#
# license:  Public Domain
#

from object import Object
import pygame

class Planet(Object):
    def tick(self):
        r = int(self.object.size / self.view.zoom) + 1
        w = int(5. / self.view.zoom) + 1
        rcolor = self.object.team.color
        color  = tuple([int(i*self.object.owned/2) for i in rcolor])
        pygame.draw.circle(self.view.screen, color,  self.pos(), r-w, 0)
        pygame.draw.circle(self.view.screen, rcolor, self.pos(), r,   w)
        