#
# file:     player.py
#
# about:    player renderer
#
# author:   Tom "Knio" Flanagan
#
# contact:  knio@h4xn3t.net
#           theknio@gmail.com
#           irc.freenode.net - Knio - #python #pygame #py
#           * comments welcome *
#
# license:  Public Domain
#

from object import Object
from space.vector import Vector
import pygame
import math

class Player(Object):

    def getImage(self):
        o = self.object
        angle = int(math.degrees(o.f)-90)/4*4 % 360
        scale = int(self.view.zoom*16)/16.
        key = angle, scale, o.user.team.color
        try:
            return self.images[key]
        except KeyError:
            image = self.makeImage(key)
            self.images[key] = image
            return image
